<?php

/**
 *
 * INDEXU
 * Copyright(C), Nicecoder, 2000-2006, All Rights Reserved.
 *
 * INDEXU(tm) is protected by Indonesia and International copyright laws.
 * Unauthorized use or distribution of INDEXU(tm) is strictly prohibited,
 * violators will be prosecuted. To obtain a license for using INDEXU(tm),
 * please register at Nicecoder home page at http://www.nicecoder.com
 *
 * Author:
 *    Dody Rachmat Wicaksono (dody@nicecoder.com)
 *    M. Zuber (zubby@nicecoder.com)
 *
 */

  /*===================================================
    ShowFormAppSetup()
  ===================================================*/

  function ShowFormAppSetup() {

    // vars global configuration
    global $dbServer, $dbHostname, $dbUsername, $dbPassword, $dbName,
      $site_url, $base_path, $theme_path, $admin_template_path,
      $spam_proof, $enable_user_validation, $allowed_file_extension,
      $google_key, $whosonline, $reciprocal_check, $urlcheck_limit, 
      $max_image_width, $max_image_height, $max_file_size,
      $only_registered_can_add_link, $only_registered_can_add_review, 
      $db_use_persistent, $paid_link_day_period, $paid_link_price_factor, 
      $pagerank_cache, $site_name, $email_address, $enable_html_tag, 
      $allowed_html_tag, $enable_page_compression;

    // vars url & form

    // vars messages

    // vars template

    $spam_proof = ShowRadioButton("spam_proof","Yes,No","1,0",$spam_proof);
    $enable_user_validation = ShowRadioButton("enable_user_validation","Yes,No","1,0",$enable_user_validation);
    $reciprocal_check = ShowRadioButton("reciprocal_check","Yes,No","1,0",$reciprocal_check);
    $only_registered_can_add_link = ShowRadioButton("only_registered_can_add_link","Yes,No","1,0",$only_registered_can_add_link);
    $only_registered_can_add_review = ShowRadioButton("only_registered_can_add_review","Yes,No","1,0",$only_registered_can_add_review);
    $db_use_persistent = ShowRadioButton("db_use_persistent","Yes,No","1,0",$db_use_persistent);
    $site_name = stripslashes($site_name);
    $email_address = stripslashes($email_address);
    $enable_html_tag = ShowRadioButton("enable_html_tag","Yes,No","1,0",$enable_html_tag);
    $allowed_html_tag = htmlspecialchars($allowed_html_tag);
    $enable_page_compression = ShowRadioButton("enable_page_compression","Yes,No","1,0",$enable_page_compression);

    DisplayTemplate($admin_template_path . "app_setup_form.html",
      "\$dbServer,\$dbHostname,\$dbUsername,\$dbPassword,\$dbName,".
      "\$site_url,\$base_path,\$theme_path,\$admin_template_path,".
      "\$spam_proof,\$enable_user_validation,\$allowed_file_extension,".
      "\$google_key,\$whosonline,\$reciprocal_check,\$urlcheck_limit,".
      "\$max_image_width,\$max_image_height,\$max_file_size,".
      "\$only_registered_can_add_link,\$only_registered_can_add_review,".
      "\$db_use_persistent,\$paid_link_day_period,\$paid_link_price_factor,".
      "\$pagerank_cache,\$site_name,\$email_address,\$enable_html_tag,".
      "\$allowed_html_tag,\$enable_page_compression");
  }


  /*===================================================
    ProcessFormAppSetup()
  ===================================================*/

  function ProcessFormAppSetup() {

    // vars global configuration
    global $dbServer, $dbHostname, $dbUsername, $dbPassword, $dbName,
      $site_url, $base_path, $theme_path, $admin_template_path,
      $spam_proof, $enable_user_validation, $allowed_file_extension, 
      $google_key, $whosonline, $reciprocal_check, $urlcheck_limit, 
      $max_image_width, $max_image_height, $max_file_size, 
      $only_registered_can_add_link, $only_registered_can_add_review, 
      $db_use_persistent, $paid_link_day_period, $paid_link_price_factor, 
      $pagerank_cache, $site_name, $email_address, $enable_html_tag, 
      $allowed_html_tag, $active_theme, $enable_page_compression;

    // vars url & form

    // vars messages
    global $msg;

    // vars template
    global $message;

    $found_exe = false;
    $found_adm_tpl = false;
    $found_theme = false;

    // check executable files inside base_path
    if (file_exists($_POST["base_path"].'indexu_exe.idf')) {
      $found_exe = true;
    }

    // check admin template files inside admin_template_path
    if (file_exists($_POST["admin_template_path"].'indexu_adm_tpl.idf')) {
      $found_adm_tpl = true;
    }

    // check theme files inside theme_path
    if (file_exists($_POST["theme_path"].'indexu_theme.idf')) {
      $found_theme = true;
    }

    if ($found_exe==false) { $error_msg = $msg["20381"]; }
    elseif ($found_adm_tpl==false) { $error_msg = $msg["20382"]; }
    elseif ($found_theme==false) { $error_msg = $msg["20383"]; }

    if(empty($error_msg)) {

      // fill

      $dbServer = $_POST["dbServer"];
      $dbHostname = $_POST["dbHostname"];
      $dbUsername = $_POST["dbUsername"];
      $dbPassword = $_POST["dbPassword"];
      $dbName = $_POST["dbName"];

      $site_url = $_POST["site_url"];
      $base_path = $_POST["base_path"];
      $theme_path = $_POST["theme_path"];
      $admin_template_path = $_POST["admin_template_path"];

      $site_name = $_POST["site_name"];
      $email_address = $_POST["email_address"];

      $spam_proof = $_POST["spam_proof"];
      $enable_user_validation = $_POST["enable_user_validation"];

      $allowed_file_extension = $_POST["allowed_file_extension"];

      $google_key = $_POST["google_key"];
      $whosonline = $_POST["whosonline"];
      $reciprocal_check = $_POST["reciprocal_check"];
      $urlcheck_limit = $_POST["urlcheck_limit"];

      $max_image_width = $_POST["max_image_width"];
      $max_image_height = $_POST["max_image_height"];
      $max_file_size = $_POST["max_file_size"];
      
      $only_registered_can_add_link = $_POST["only_registered_can_add_link"];
      $only_registered_can_add_review = $_POST["only_registered_can_add_review"];
      $db_use_persistent = $_POST["db_use_persistent"];

      $paid_link_day_period = $_POST["paid_link_day_period"];
      $paid_link_price_factor = $_POST["paid_link_price_factor"];
      $pagerank_cache = $_POST["pagerank_cache"];

      $enable_html_tag = $_POST["enable_html_tag"];
      $allowed_html_tag = $_POST["allowed_html_tag"];
      $enable_page_compression = $_POST["enable_page_compression"];

      // write to file

      $fp = fopen($base_path . 'application.php', 'w+');

      $content = EvalTemplate($admin_template_path . "application.cfg.php",
        "\$dbServer,\$dbHostname,\$dbUsername,\$dbPassword,\$dbName,".
        "\$site_url,\$base_path,\$theme_path,\$admin_template_path,".
        "\$spam_proof,\$enable_user_validation,\$bold_keyword,\$bold_format,".
        "\$allowed_file_extension,\$google_key,\$whosonline,\$reciprocal_check,".
        "\$urlcheck_limit,\$max_image_width,\$max_image_height,\$max_file_size,".
        "\$only_registered_can_add_link,\$only_registered_can_add_review,".
        "\$db_use_persistent,\$paid_link_day_period,\$paid_link_price_factor,".
        "\$pagerank_cache,\$site_name,\$email_address,\$enable_html_tag,".
        "\$allowed_html_tag,\$active_theme,\$enable_page_compression");
      fwrite($fp,$content);


      $message = $msg["20384"];
    }
    else $message = $error_msg;

    DisplayTemplate($admin_template_path . "message.html", "\$message");
  }


  /*===================================================
    main
  ===================================================*/

  include "../application.php";
  
  RunPreFilter(__FILE__);

  DisplayTemplate($admin_template_path . "header.html");
  if (empty($pflag)) {
    ShowFormAppSetup();
  }
  elseif($pflag=='setup') {
    ProcessFormAppSetup();
  }
  DisplayTemplate($admin_template_path . "footer.html");

  RunPostFilter(__FILE__);

?>